<?php

namespace App\Http\Controllers\Admin\Location;

use App\Http\Controllers\Controller;
use App\Http\Requests\StoreCountryRequest;
use App\Http\Requests\UpdateCountryRequest;
use App\Models\Country;

class CountryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $countries = Country::withCount(['states', 'cities'])->orderBy('name')->get();

        return view('admin.location.country.index', compact('countries'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $country = new Country;

        return view('admin.location.country.create', compact('country'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreCountryRequest $request)
    {
        $data = $request->validated();
        $data['status'] = $request->has('status');
        $data['flag'] = $request->file('flag')->store('countries', 'public');

        try {
            Country::create($data);

            return redirect()->route('admin.location.country.index')->with('success', 'Country created successfully.');
        } catch (\Exception $e) {
            return $e->getMessage();

            return redirect()->back()->with('error', 'Country could not be created.');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Country $country)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Country $country)
    {
        return view('admin.location.country.create', compact('country'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateCountryRequest $request, Country $country)
    {
        $data = $request->validated();

        $data['status'] = $request->has('status');
        if ($request->has('flag')) {
            $data['flag'] = $request->file('flag')->store('countries', 'public');
        }

        try {
            $country->update($data);

            return redirect()->route('admin.location.country.index')->with('success', 'Country updated successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Country could not be updated.');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Country $country)
    {
        try {
            $country->delete();
            $country->states()->delete();
            $country->cities()->delete();

            return response()->json(['message' => 'Country deleted successfully.', 'status' => 'success']);
        } catch (\Exception $e) {
            return response()->json(['message' => 'Country could not be deleted.', 'status' => 'error'], 500);
        }
    }
}
